package control;

import abstraction.Action;

/**
 * @author Balestra Concetta, Qusa Hani
 * @version 1.2 09/04/05
 * @since JDK 1.6
 */

/**
 * Class to contain a couple of states which are in simulation with the action for that they are simulated
 *
 */
public class OrchestratorKey {

	private SimulatedBy s;
	private Action action;

	public OrchestratorKey(SimulatedBy s, Action action) {
		this.s = s;
		this.action = action;
	}
	
	/**
	 * gets the pair of states which are in this orchestrator key
	 * @return an object SimulatedBy that represents the pair of states
	 */
	public SimulatedBy getSimulatedBy() {
		return this.s;
	}

	/**
	 * gets the action which is part of this orchestrator key
	 * @return an action
	 */
	public Action getAction() {
		return this.action;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			OrchestratorKey other = (OrchestratorKey) o;
			return this.s.equals(other.getSimulatedBy())
					&& this.action.equals(other.getAction());
		} else
			return false;
	}

	public int hashCode() {
		return (this.s.hashCode() + this.action.hashCode());
	}

	public String toString() {
		String str = new String();
		str = str.concat(s.toString());
		str = str.concat(action.toString());
		return str;
	}
}
